#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <math.h>

#define LS_ORDER_MAX 20

//int ls_order=10;
int ls_order=-1;

int solution_tmp[LS_ORDER_MAX][LS_ORDER_MAX];

int count_transversals_helper(int start_at_row, int cur_transversal_vals, int cnt, int cur_cols_in_transversal)
{
        assert (ls_order>0);
        //int BITMASK=0x3ff; // for order=10
        int BITMASK=(1<<ls_order)-1;

        if (cur_transversal_vals==BITMASK)
                return cnt+1;

        if (start_at_row==ls_order)
                return cnt; // finish
        for (int i=0; i<ls_order; i++)
        {
                int i_bitmask=1<<i;
                // col must not repeat in transversal:
                if ((i_bitmask & cur_cols_in_transversal) != 0)
                        continue;

                int val=solution_tmp[start_at_row][i];
                if ((val & cur_transversal_vals) == 0)
                        cnt=count_transversals_helper(start_at_row+1, cur_transversal_vals | val, cnt, cur_cols_in_transversal | i_bitmask);
        }
        return cnt;
};

int count_transversals_short(const char *s)
{
        //printf("count_transversals_short: %s\n", s);
        for (int r=0; r<ls_order; r++)
                for (int c=0; c<ls_order; c++)
                {
                        //solution_tmp[r][c]=1<<(s[r*ls_order+c]-'0');
                        char buf[3];
                        buf[1]=0;
                        buf[0]=s[r*ls_order+c];
                        int symb=strtol(buf, NULL, 16);
                        solution_tmp[r][c]=1<<symb;
                };
        return count_transversals_helper(0, 0, 0, 0);
};

int main()
{
        FILE *fp=stdin;
        char buf[1024];
        while (fgets(buf, 1024, fp))
        {
                int str_len=-1;
                for (int i=0; ; i++)
                {
                        if ((isdigit(buf[i])==0) && (islower(buf[i])==0))
                        {
                                str_len=i;
                                break;
                        };
                };
                //printf ("str_len=%d\n", str_len);
                if (str_len==0)
                        continue;
                ls_order=(int)sqrt((float)str_len);
                //printf ("ls_order=%d\n", ls_order);
                assert (ls_order*ls_order==str_len);
                assert (ls_order<LS_ORDER_MAX);
                buf[str_len]=0;
                //printf ("%d %s", count_transversals_short(buf), buf);
                printf ("%d %s\n", count_transversals_short(buf), buf);
        };
};
