#!/usr/bin/env python3

import sys, os, subprocess, tempfile, latin_utils, hashlib

prefix=sys.argv[1]

def normalize_s(s):
    x=latin_utils.base36_str_to_list_of_lists(s)
    y=latin_utils.normalize(x)
    return latin_utils.list_of_lists_of_int_to_base36_str(y)

def process (sq):
    if len(sq)>=289:
        log_fname=prefix+"_"+hashlib.md5(sq.encode("utf-8")).hexdigest()+".log"
    else:
        log_fname=f"{prefix}_{sq}.log"
    if os.path.exists(log_fname):
        return 0
    sq=normalize_s(sq)
    log_fname=f"{prefix}_{sq}.log"
    if os.path.exists(log_fname):
        return 0
    cmd=f"./random_walk_maxsat.py {sq} > {log_fname}"
    print (cmd)
    os.system(cmd)
    return 1

#f=open(prefix+"_seed")
f=open(sys.argv[1])
for l in f:
    l=l.rstrip()
    process(l)

exit(0)

with tempfile.NamedTemporaryFile() as tmp:
    TMP=tmp.name

    while True:

        # min or max?
        #os.system(f"cat {prefix}_*.log | grep transv_cnt | sort | uniq > {TMP}") # min
        os.system(f"cat {prefix}_*.log | grep transv_cnt | sort | tac | uniq > {TMP}") # max

        for y in open(TMP):
            y=y.rstrip()
            q=y.split(" ")
            TS=q[0].split("=")[1]
            short=q[1].split("=")[1]
            #print (int(TS), short)
            done=process(short)
            if done==1:
                break
