#!/usr/bin/python3

from z3 import *

OUTPUTS=[
0.5796002421038544,
0.12380356735099862,
0.3164341640263062]

def get_53bit_mantissa(i):
    # 0x1.0p-53:
    divisor=0.00000000000000011102230246251565404236316680908203125
    return int(i//divisor)

STATES=len(OUTPUTS)

a_ = BitVec('state_a_', 64)
b_ = BitVec('state_b_', 64)

def RandUint64():
    global a_, b_
    t = a_
    s = b_

    a_ = s
    t = t ^ (t << 23)
    t = t ^ (LShR(t, 17))
    t = t ^ (s ^ (LShR(s, 26)))
    b_ = t

    return t + s

s = Solver()

results_=[]
for i in range(len(OUTPUTS)):
    x=RandUint64()
    results_.append(x)

for i in range(len(OUTPUTS)):
    _53_mask=(1<<53)-1
    c=get_53bit_mantissa(OUTPUTS[i])
    rounding_errors=1
    s.add((results_[i] & _53_mask) > (c-rounding_errors))
    s.add((results_[i] & _53_mask) < (c+rounding_errors))

# enumerate all solutions:
results=[]
while s.check() == sat:
    m = s.model()
    print (m)
    results.append(m)
    block = []
    for d in m:
        t=d()
        block.append(t != m[d])
    s.add(Or(block))

print ("results total=", len(results))

