#!/usr/bin/python3

from z3 import *

ZEROES=6

STATES=ZEROES

s = Solver()

a_ = BitVec('state_a_', 64)
b_ = BitVec('state_b_', 64)

s.add(a_!=0)
s.add(b_!=0)

def RandUint64():
    global a_, b_
    t = a_
    s = b_

    a_ = s
    t = t ^ (t << 23)
    t = t ^ (LShR(t, 17))
    t = t ^ (s ^ (LShR(s, 26)))
    b_ = t

    return t + s

results_=[]
for i in range(ZEROES):
    x=RandUint64()
    results_.append(x)

for i in range(ZEROES):
    _53_mask=(1<<53)-1
    rounding_errors=1<<31
    s.add((results_[i] & _53_mask) > 0)
    s.add((results_[i] & _53_mask) < rounding_errors)

# enumerate all solutions:
results=[]
while s.check() == sat:
    m = s.model()
    print (m)
    results.append(m)
    block = []
    for d in m:
        t=d()
        block.append(t != m[d])
    s.add(Or(block))

print ("results total=", len(results))

